using System;
using System.IO;

namespace KensNET
{
	public static class Enigma
	{
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Program entry point
		public static long EDecomp(string SrcFile, string DstFile, long Pointer, bool padding)
		{
			byte packet_length = 0;
			byte mode = 0;
			short output_repeatcount = 0;
			byte bitmask = 0;
			ushort incrementing_value = 0;
			ushort common_value = 0;
			ushort outvalue = 0;
						
			FileStream infile, outfile;
			int offset = 0;
			byte[] data, outData, paddingData;
			int outoffset = 0;
			bool done = false;
			
			int remaining_bits = 8;
			byte input_buffer;

		// There starts the original code by Nemesis (all Console I/O operations were removed)
			if (!File.Exists(SrcFile))
			{
				//		cout << "\n\nInvalid rom filename!";
				return -1; 
			}
			infile = new FileStream(SrcFile, FileMode.Open);
			data = new byte[infile.Length];
			outData = new byte[0x100000];
			paddingData = new byte[0x1000];
			
			infile.Read(data, 0, data.Length);
			
			offset = (int)Pointer;
			input_buffer = data[offset++];
				
		/////////////////////////////////////////////////////////////////////////////////////////
		//Entry point
			packet_length = getbits(8, data, ref offset, ref input_buffer, ref remaining_bits);
			bitmask = getbits(8, data, ref offset, ref input_buffer, ref remaining_bits);
			incrementing_value = (ushort)(getbits(8, data, ref offset, ref input_buffer, ref remaining_bits) << 8);
			incrementing_value |= getbits(8, data, ref offset, ref input_buffer, ref remaining_bits);
			common_value = (ushort)(getbits(8, data, ref offset, ref input_buffer, ref remaining_bits) << 8);
			common_value |= getbits(8, data, ref offset, ref input_buffer, ref remaining_bits);
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Main algorithm
			for(;!done;)
			{
				if((getbits(1, data, ref offset, ref input_buffer, ref remaining_bits)) == 1)
				{
					mode = getbits(2, data, ref offset, ref input_buffer, ref remaining_bits);
					switch(mode)
					{
					case 0:
					case 1:
					case 2:
						{
							output_repeatcount = getbits(4, data, ref offset, ref input_buffer, ref remaining_bits);
							outvalue = getvalue(packet_length, data, ref offset, ref input_buffer, ref remaining_bits, bitmask);
							for(;output_repeatcount >= 0; output_repeatcount--)
							{
								outData[outoffset++] = (byte)((outvalue >> 8) & 0x00FF);
								outData[outoffset++] = (byte)(outvalue & 0x00FF);
								
								switch(mode)
								{
								case 0:
									break;
								case 1:
									outvalue++;
									break;
								case 2:
									outvalue--;
									break;
								}
							}
							break;
						}
					case 3:
						{
							output_repeatcount = getbits(4, data, ref offset, ref input_buffer, ref remaining_bits);
							if(output_repeatcount != 0x0F)
							{
								for(;output_repeatcount >= 0; output_repeatcount--)
								{
									outvalue = getvalue(packet_length, data, ref offset, ref input_buffer, ref remaining_bits, bitmask);
									outData[outoffset++] = (byte)((outvalue >> 8) & 0x00FF);
									outData[outoffset++] = (byte)(outvalue & 0x00FF);
								}
							}
							else
							{
								done = true;
							}
							break;
						}
					}
				}
				else
				{
					if((getbits(1, data, ref offset, ref input_buffer, ref remaining_bits)) == 0)
					{
						output_repeatcount = getbits(4, data, ref offset, ref input_buffer, ref remaining_bits);
						for(; output_repeatcount >= 0; output_repeatcount--)
						{
							outData[outoffset++] = (byte)((incrementing_value >> 8) & 0x00FF);
							outData[outoffset++] = (byte)(incrementing_value & 0x00FF);
							incrementing_value++;
						}
					}
					else
					{
						output_repeatcount = getbits(4, data, ref offset, ref input_buffer, ref remaining_bits);
						for(; output_repeatcount >= 0; output_repeatcount--)
						{
							outData[outoffset++] = (byte)((common_value >> 8) & 0x00FF);
							outData[outoffset++] = (byte)(common_value & 0x00FF);
						}
					}
				}
			}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Output completed file
			outfile = new FileStream(DstFile, FileMode.Create);
			
			if(padding)
			{
				outfile.Write(paddingData, 0, 0x1000);
				for(int loopcount = 0; loopcount < 0x2000; loopcount += 0x80)
				{
					outfile.Write(paddingData, 0, 0x20);
					outfile.Write(outData, (loopcount/2), 0x40);
					outfile.Write(paddingData, 0, 0x20);
				}
				outfile.Write(paddingData, 0, 0x1000);
			}
			else
			{
				outfile.Write(outData, 0, outoffset);
			}
		
		//	printf("Done!\n\n");
		//	printf("Archive in %s successfully extracted to file %s.\n\n", argv[1], argv[2]);
		//	printf("Compressed file size:\t\t0x%X\t\t%i\n", (offset - originaloffset), (offset - originaloffset));
		//	printf("Uncompressed file size:\t\t0x%X\t\t%i\n", _tell(outfile), _tell(outfile));
		//	printf("Location in file:\t\t0x%X - 0x%X\n", originaloffset, offset);
		//	printf("Compression rate:\t\t%.2f%%\n\n", (100 - (((float)(offset - originaloffset) / (float)(_tell(outfile))) * 100)));
		
			outfile.Close();
			infile.Close();
			return 0;
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Getvalue function		- This function extracts a 16-bit value from the compressed data.
		private static ushort getvalue(byte packet_length, byte[] data, ref int offset, ref byte input_buffer, ref int remaining_bits, byte bitmask)
		{
			ushort outvalue, addvalue = 0;
			for(int loopcount = 0; loopcount < 5; loopcount++)
			{
				if(((bitmask >> (4 - loopcount)) & 0x01) != 0)
				{
					addvalue |= (ushort)(getbits(1, data, ref offset, ref input_buffer, ref remaining_bits) << (0xF - loopcount));
				}
			}
		
			if(packet_length > 8)
			{
				outvalue = (ushort)(getbits(packet_length - 8, data, ref offset, ref input_buffer, ref remaining_bits) << 8);
				outvalue |= getbits(8, data, ref offset, ref input_buffer, ref remaining_bits);
			}
			else
			{
				outvalue = getbits(packet_length, data, ref offset, ref input_buffer, ref remaining_bits);
			}
		
			outvalue &= (ushort)(0xFFFF ^ (0xFFFF << packet_length));
			outvalue += addvalue;
			return outvalue;
		}
		
		
		private static byte getbits(int number, byte[] input, ref int offset, ref byte input_buffer, ref int remaining_bits)
		{
			byte val = 0;
		
			if(number > remaining_bits)
			{
				val = (byte)(input_buffer >> (8 - number));
				input_buffer = input[offset++];
				val |= (byte)((input_buffer & (0xFF << (8 - number + remaining_bits))) >> (8 - number + remaining_bits));
				input_buffer <<= (number - remaining_bits);
				remaining_bits = 8 - (number - remaining_bits);
			}
			else
			{
				val = (byte)((input_buffer & (0xFF << (8 - number))) >> (8 - number));
				remaining_bits -= number;
				input_buffer <<= number;
			}
		
			return val;
		}
		
	}
}

