using System;
using System.IO;

namespace KensNET
{
	public class Kosinski
	{
		public Kosinski (){}
		
		public enum KResult{
			SUCCESS, ERROR_UNKNOWN, ERROR_FILE_NOT_FOUND, ERROR_MODULED_GREATHER_THAN_65535
		}
		
		public static KResult KDecomp(string srcFile, string dstFile, long location, bool Moduled)
		{
			// Files
			FileStream src, dst;
			
			// Bitfield Infos
			ushort BITFIELD;
			byte BFP;
			byte Bit;
			
			// R/W infos
			byte Byte;
			byte Low, High;
			
			// Localization Infos
			int Pointer;
				
			// Count and Offest
			long Count = 0;
			long Offset = 0;
			
			// Moduled infos
			long FullSize = 0;
			long DecBytes = 0;
			
			//------------------------------------------------------------------------------------------------
			if (!File.Exists(srcFile)) return KResult.ERROR_FILE_NOT_FOUND;
			src = new FileStream(srcFile, FileMode.Open);
			dst = new FileStream(dstFile, FileMode.Create);
			
			src.Seek(location, SeekOrigin.Begin);
			
			if (Moduled)
			{
				High = (byte)src.ReadByte();
				Low = (byte)src.ReadByte();
				FullSize = ((long)High << 8) + (long)Low;
			}
		
			start:
				BITFIELD = ReadShort(src);
				BFP=0;
			
			//------------------------------------------------------------------------------------------------
				while(true)
				{
					if((BITFIELD & (1<<BFP++)) > 0) Bit=1; else Bit=0;
					if (BFP>=16) { BITFIELD=ReadShort(src); BFP=0; }
			//-- Direct Copy ---------------------------------------------------------------------------------
					if (Bit > 0)
					{
						dst.WriteByte((byte)src.ReadByte());
						DecBytes+=1;
					}
					else
					{
						if((BITFIELD & (1<<BFP++))>0) Bit=1; else Bit=0;
						if (BFP>=16) { BITFIELD = ReadShort(src); BFP=0; }
			//-- Embedded / Separate -------------------------------------------------------------------------
						if (Bit > 0)
						{
							Low = (byte)src.ReadByte();
							High = (byte)src.ReadByte();
			
							Count=(long)(High & 0x07);
			
							if (Count==0)
							{
								Count = (byte)src.ReadByte();
								if (Count==0) break;
								if (Count==1) continue;
							}
							else
							{
								Count+=1;
						    }
			
							Offset = 0xFFFFE000 | ((long)(0xF8 & High) << 5) | (long)Low;
						}
			//-- Inline --------------------------------------------------------------------------------------
						else
						{
							if((BITFIELD & (1<<BFP++))>0) Low=1; else Low=0;
							if (BFP>=16) { BITFIELD=ReadShort(src); BFP=0; }
							if((BITFIELD & (1<<BFP++))>0) High=1; else High=0;
							if (BFP>=16) { BITFIELD = ReadShort(src); BFP=0; }
			
							Count = ((long)Low)*2 + ((long)High) + 1;
			
							Offset = src.ReadByte();
							Offset|=0xFFFFFF00;
						}
			//-- Write to file for indirect copy -------------------------------------------------------------
						if(Offset > 0x80000000) Offset-=0x100000000; //Longs are 64-bit in C#. Negate them manually
						for (int i=0; i<=Count; i++)
						{
							Pointer=(int)dst.Position;
							dst.Seek(Offset, SeekOrigin.Current);
							Byte = (byte)dst.ReadByte();
							dst.Seek(Pointer, SeekOrigin.Begin);
							dst.WriteByte(Byte);
						}
						DecBytes+=Count+1;
			//------------------------------------------------------------------------------------------------
					}
				}
			//------------------------------------------------------------------------------------------------
			
//			end:
				if (Moduled)
				{
					if (DecBytes < FullSize)
					{
						do { Byte=(byte)src.ReadByte(); } while (Byte==0);
						src.Seek(-1, SeekOrigin.Current);
						goto start;
					}
				}
				dst.Close();
				src.Close();
				return KResult.SUCCESS;
			}
		
		/// <summary>
		/// Read a short as little endian
		/// </summary>
		private static ushort ReadShort(FileStream strm){
			byte[] arr = new byte[2];
			strm.Read(arr, 0, 2);
			return (ushort)((arr[0]) + (arr[1] << 8)); 
		}
	}
}

