using System;
using System.IO;

namespace KensNET
{
	public static class Nemesis
	{
		
		public static long NDecomp(string SrcFile, string DstFile, long Pointer)
		{
		// In the following code, I removed the declaration of the Pointer variable as it is now passed
		// as parameters. I also removed all console I/O operation as the function does not need to ask
		// for filenames and for a pointer, as they are passed as parameters.
		
		//set input and output modes to hex
		//	cin.setf(ios::hex);
		
		//misc variables and arrays
			FileStream openrom, file;
			int result = 0, out_loc = 0, loopcount = 0, romsize = 0;
			long pointer = Pointer; //place in the rom to load from */
			ushort rtiles; //remaining tiles to decompress
			bool alt_out = false; //flag to change between the two different output modes
			ulong[] tiles = new ulong[0x8000]; //output array
			string romfilename; //name of rom */
			string outfilename; //name of output file */
		
		// We set up romfilename and outfilename according to the passed parameters
			romfilename = SrcFile;
			outfilename = DstFile;
			
			if(!File.Exists(romfilename))
			{
				return -1;
			}
			openrom = new FileStream(romfilename, FileMode.Open);
			romsize = (int)openrom.Length;
			byte[] romData = new byte[romsize];
			openrom.Read(romData, 0, romsize);

		//allocates block of memory for decompression buffer
			byte[] bufferData = new byte[0x200];
		
		// There starts the original code by Nemesis
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//entry point into algorithm
			rtiles = (ushort)(romData[pointer++]*0x100);
			rtiles += (ushort)(romData[pointer++] & 0xFF);
			alt_out = ((rtiles & 0x8000) / 0x8000)>0; //ses the output mode based on the value of the first bit
			rtiles = (ushort)(0x7FFF & rtiles); //truncates the first bit as it is no longer significant
			result = stage_1(ref pointer, ref romData, ref bufferData); //calls the header decompression routine
			if(result == -1)
			{
				return -1;
			}
			stage_2(ref pointer, ref romData, ref bufferData, ref tiles, (short)rtiles, alt_out, ref out_loc); //calls the main decompression routine
		
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Additional filehanding to read decompressed tiles from memory into file
			file = new FileStream(outfilename, FileMode.Create);
			for(loopcount = 0; loopcount < out_loc; loopcount++)
			{
				tiles[loopcount] = ((tiles[loopcount] & 0xFF000000) / 0x1000000) + 
								   ((tiles[loopcount] & 0xFF0000) / 0x100) + 
								   ((tiles[loopcount] & 0xFF00) *0x100) + 
								   ((tiles[loopcount] & 0xFF) * 0x1000000); //byteswaps the output before writing to the output file
				file.WriteByte((byte)(tiles[loopcount]&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>8)&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>16)&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>24)&0xFF));
			}
			file.Close();
			openrom.Close();
			return 0;
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//First stage decompression algorithm
		private static int stage_1 (ref long pointer, ref byte[] romData, ref byte[] bufferData)
		{
			ushort in_val; //storage for value coming from rom
			ushort out_val=0; //storage for output value to decompression buffer
			ushort num_times; //number of times the calculated output value is written to the buffer
			ushort offset; //stores buffer offset to write to
			//main loop. Header is terminated by the value of 0xFF in the rom
			for (in_val = (ushort)(romData[pointer++] & 0xFF); in_val != 0xFF; in_val = (ushort)(romData[pointer++] & 0xFF))
			{
				if(in_val > 0x7F) //if most significant bit is set, store the last 4 bits and discard the rest
				{
					out_val = in_val; //last four bits set here are not changed until it enters here again
					in_val = (ushort)(romData[pointer++] & 0xFF); //read another value from the rom
				}
				num_times = (ushort)(0x08 - (in_val & 0x0F)); //the last 4 bits here determine the number of times the value is written to the buffer. Never greater than 8
				in_val = (ushort)(((in_val & 0xF0) / 0x10) + ((in_val & 0x0F) * 0x10)); //nibble swap the value from the rom
				out_val = (ushort)((out_val & 0x0F) + (in_val * 0x10)); //multiply the input value by 0x10 and place it in front of the last 4 bits in the output value
				offset = (ushort)((romData[pointer++] & 0xFF) * (1 << (num_times + 1))); //read another value from the rom and use it to determine the offset
				if(offset >= 0x200)
				{
					return -1;
				}
		
				num_times = (ushort)(1 << num_times); //finish setting the number of times the value is written to the buffer
				for(; num_times != 0; num_times--,offset += 2) //loop for writing the values to the buffer
				{
					bufferData[offset+1] = (byte)(out_val & 0x00FF);
					bufferData[offset] = (byte)((out_val & 0xFF00) / 0x100); //wriiting the values to the buffer
				}
			}
			return 0;
		}
		
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Second stage decompression algorithm
		private static void stage_2 (ref long pointer, ref byte[] romData, ref byte[] bufferData, ref ulong[] tiles, short rtiles, bool alt_out, ref int out_loc)
		{
			ushort rnibbles; //remaining nibbles in this line
			ulong out_val; //output value
			ushort rom_mod = 0x10; //This one is complex. Used in maths as a power of 2, but also controls when 
											//new values are read from the rom. Just read the algorithm.
			ulong alt_out_val = 0; //If the alternate output method is used by this archive, each line is XOR'd with
										   //the line before it prior to writing to the output.
			ushort rlines; //remaining lines to decompress in this tile
			ushort mode_val; //There are two different things it can do in the main loop. This holds the value to switch between them
			ushort bufferoffset; //the buffer offset to read from next
			ushort next_out = 0; //the next nibble to be added to the output.
			short num_times = 0; //the number of times the value is repeated in the output
			
			ushort rom_val = (ushort)(romData[pointer++]*0x100); //value from the rom
			rom_val += (ushort)(romData[pointer++] & 0xFF);
			for(;rtiles > 0;rtiles--) //main loop for tiles
			{
				for (rlines = 8; rlines != 0; rlines--) //loop for lines in the tile
				{
					for (out_val = 0, rnibbles = 8; rnibbles != 0; rnibbles--) //loop for nibbles in the line
					{
						num_times--; //decrements number of times to write current value to output
						if (num_times == -1) //if -1, calculate new value
						{
							mode_val = (ushort)(rom_val / (1 << (rom_mod - 8))); //determines which set of commands to perform
							if ((mode_val & 0x00FF) >= 0xFC) //determining value is 0xFC or greater
							{
								if (rom_mod < 0x0F) //determines whether or not to read another value from the rom
								{
									rom_mod += 8; //and adds 8 to rom_mod if it does
									rom_val = (ushort)((rom_val * 0x100) + (romData[pointer++] & 0xFF));
								}
								rom_mod -= 0x0D; //subtracts 0x0D from rom_mod
								num_times = (short)(((short)(rom_val / (2 << rom_mod)) & 0x70) / 0x10); //calculates number of times to write value to output
								next_out = (ushort)((short)(rom_val / (2 << rom_mod)) & 0x0F); //calculates next output value
							}
							else
							{
								bufferoffset = (ushort)((mode_val & 0xFF) * 2); //sets buffer offset
								rom_mod -= bufferData[bufferoffset]; //reads a buffer value, then subtracts it from rom_mod. Never greater than 0x7
								num_times = (short)((bufferData[bufferoffset+1] & 0xF0) / 0x10); //set number of times based on a buffer value. Never greater than 0x7
								next_out = (ushort)((bufferData[bufferoffset+1]) & 0x0F); //gets next output value from buffer
							}
							if (rom_mod < 9) //again, potentially load a value from the rom
							{
								rom_mod += 8; //and add 8 to rom_mod
								rom_val = (ushort)((rom_val * 0x100) + (romData[pointer++] & 0xFF));
							}
						}
						out_val = out_val * 0x10 + next_out; //adds next value to output
					}
					if (alt_out == false)
					{
						tiles[out_loc++] = out_val; //writes next line to output array
					}
					else
					{
						alt_out_val = alt_out_val ^ out_val; //Alternate output method. Only bits set are those different to the last line
						tiles[out_loc++] = alt_out_val;
					}
				}
			}
		}

		
	}
}

