using System;
using System.IO;

namespace KensNET
{
	public static class Saxman
	{
		/*** Note: I think there is a bug here somewhere. Output appears to be correct, but sometimes incomplete? ***/
		
		public enum SResult{
			SUCCESS, ERROR_UNKNOWN, ERROR_FILE_NOT_FOUND
		}
				
		//-----------------------------------------------------------------------------------------------
		// Name: SDecomp(char *SrcFile, char *DstFile, long Location, unsigned short Size)
		// Desc: Decompresses the data using the Saxman compression format
		//-----------------------------------------------------------------------------------------------
		public static SResult SDecomp(string srcFile, string dstFile, long location, ushort size)
		{
		// Files
			FileStream src;
			FileStream dst;
		
		// Info Byte, Flag, Count and Offset (with initial values)
			byte InfoByte = 0;
			byte IBP = 8;
			byte Flag = 0;
			byte Count = 0;
			ushort Offset = 0;
		//	unsigned short Size = 0;		// Size of the compressed data
		
		// Other info
			byte scratchByte;				// Used to store a Byte temporarly
			int Pointer;					// Used to store a Pointer temporarly
			int i;							// Counter
		
		//------------------------------------------------------------------------------------------------
		
			if (!File.Exists(srcFile)) return SResult.ERROR_FILE_NOT_FOUND;
			src = new FileStream(srcFile, FileMode.Open);
			dst = new FileStream(dstFile, FileMode.Create);
		
			src.Seek(location, SeekOrigin.Begin);
			
			if (size==0) size = ReadShort(src);
		
			while(true)
			{
				if (IBP==8) { IBP=0; if ((InfoByte=(byte)src.ReadByte())==0) break; if (src.Position >= location + size) break; }
				Flag = (byte)(( InfoByte >> (IBP++) ) & 1);
				switch(Flag)
				{
					case 0:
						Offset=0; // See 3 lines below
						if ((Offset=(ushort)src.ReadByte())==0) break; if (src.Position >= location + size) break;
						if ((Count=(byte)src.ReadByte())==0) break; if (src.Position >= location + size) break;
						Offset = (ushort)(( Offset | ((Count & 0xF0) << 4) ) + 0x12); // Can be improved
						Offset |= (ushort)(dst.Position & 0xF000);
						Count&=0x0F;
						Count+=3;
						if(Offset>=dst.Position)
						{
							Offset -= 0x1000;
						}
						if (Offset<dst.Position)
						{
							for (i=0; i<Count; ++i)
							{
								Pointer=(int)dst.Position;
								dst.Seek(Offset + i, SeekOrigin.Begin);
								if ((scratchByte=(byte)dst.ReadByte())==0) break;
								dst.Seek(Pointer, SeekOrigin.Begin);
								dst.WriteByte(scratchByte);
							}
						}
						else
						{
							scratchByte=0;
							for (i=0; i<Count; ++i)
							{
								dst.WriteByte(scratchByte);
							}
						}
						break;
		
					case 1:
						if ((scratchByte = (byte)src.ReadByte())==0) break; if (src.Position >= location + size) break;
						dst.WriteByte(scratchByte);
						break;
				}
			}
		
		//------------------------------------------------------------------------------------------------
		
			dst.Close();
			src.Close();
			return SResult.SUCCESS;
		}
		
		private static ushort ReadShort(FileStream strm){
			byte[] arr = new byte[2];
			strm.Read(arr, 0, 2);
			return (ushort)((arr[0]) + (arr[1] << 8)); 
		}
		
	}
}

