using System;
using System.IO;

/** Nemesis Decompression and Compression Routines
 * 
 * Ported almost line-by-line from the KENS libraries C source code.
 * */

namespace KensNET
{
	public static class Nemesis
	{
		
		public static long NDecomp(string SrcFile, string DstFile, long Pointer)
		{
		// In the following code, I removed the declaration of the Pointer variable as it is now passed
		// as parameters. I also removed all console I/O operation as the function does not need to ask
		// for filenames and for a pointer, as they are passed as parameters.
		
		//set input and output modes to hex
		//	cin.setf(ios::hex);
		
		//misc variables and arrays
			FileStream openrom, file;
			int result = 0, out_loc = 0, loopcount = 0, romsize = 0;
			long pointer = Pointer; //place in the rom to load from */
			ushort rtiles; //remaining tiles to decompress
			bool alt_out = false; //flag to change between the two different output modes
			ulong[] tiles = new ulong[0x8000]; //output array
			string romfilename; //name of rom */
			string outfilename; //name of output file */
		
		// We set up romfilename and outfilename according to the passed parameters
			romfilename = SrcFile;
			outfilename = DstFile;
			
			if(!File.Exists(romfilename))
			{
				return -1;
			}
			openrom = new FileStream(romfilename, FileMode.Open);
			romsize = (int)openrom.Length;
			byte[] romData = new byte[romsize];
			openrom.Read(romData, 0, romsize);

		//allocates block of memory for decompression buffer
			byte[] bufferData = new byte[0x200];
		
		// There starts the original code by Nemesis
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//entry point into algorithm
			rtiles = (ushort)(romData[pointer++]*0x100);
			rtiles += (ushort)(romData[pointer++] & 0xFF);
			alt_out = ((rtiles & 0x8000) / 0x8000)>0; //ses the output mode based on the value of the first bit
			rtiles = (ushort)(0x7FFF & rtiles); //truncates the first bit as it is no longer significant
			result = stage_1(ref pointer, ref romData, ref bufferData); //calls the header decompression routine
			if(result == -1)
			{
				return -1;
			}
			stage_2(ref pointer, ref romData, ref bufferData, ref tiles, (short)rtiles, alt_out, ref out_loc); //calls the main decompression routine
		
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Additional filehanding to read decompressed tiles from memory into file
			file = new FileStream(outfilename, FileMode.Create);
			for(loopcount = 0; loopcount < out_loc; loopcount++)
			{
				tiles[loopcount] = ((tiles[loopcount] & 0xFF000000) / 0x1000000) + 
								   ((tiles[loopcount] & 0xFF0000) / 0x100) + 
								   ((tiles[loopcount] & 0xFF00) *0x100) + 
								   ((tiles[loopcount] & 0xFF) * 0x1000000); //byteswaps the output before writing to the output file
				file.WriteByte((byte)(tiles[loopcount]&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>8)&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>16)&0xFF));
				file.WriteByte((byte)((tiles[loopcount]>>24)&0xFF));
			}
			file.Close();
			openrom.Close();
			return 0;
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//First stage decompression algorithm
		private static int stage_1 (ref long pointer, ref byte[] romData, ref byte[] bufferData)
		{
			ushort in_val; //storage for value coming from rom
			ushort out_val=0; //storage for output value to decompression buffer
			ushort num_times; //number of times the calculated output value is written to the buffer
			ushort offset; //stores buffer offset to write to
			//main loop. Header is terminated by the value of 0xFF in the rom
			for (in_val = (ushort)(romData[pointer++] & 0xFF); in_val != 0xFF; in_val = (ushort)(romData[pointer++] & 0xFF))
			{
				if(in_val > 0x7F) //if most significant bit is set, store the last 4 bits and discard the rest
				{
					out_val = in_val; //last four bits set here are not changed until it enters here again
					in_val = (ushort)(romData[pointer++] & 0xFF); //read another value from the rom
				}
				num_times = (ushort)(0x08 - (in_val & 0x0F)); //the last 4 bits here determine the number of times the value is written to the buffer. Never greater than 8
				in_val = (ushort)(((in_val & 0xF0) / 0x10) + ((in_val & 0x0F) * 0x10)); //nibble swap the value from the rom
				out_val = (ushort)((out_val & 0x0F) + (in_val * 0x10)); //multiply the input value by 0x10 and place it in front of the last 4 bits in the output value
				offset = (ushort)((romData[pointer++] & 0xFF) * (1 << (num_times + 1))); //read another value from the rom and use it to determine the offset
				if(offset >= 0x200)
				{
					return -1;
				}
		
				num_times = (ushort)(1 << num_times); //finish setting the number of times the value is written to the buffer
				for(; num_times != 0; num_times--,offset += 2) //loop for writing the values to the buffer
				{
					bufferData[offset+1] = (byte)(out_val & 0x00FF);
					bufferData[offset] = (byte)((out_val & 0xFF00) / 0x100); //wriiting the values to the buffer
				}
			}
			return 0;
		}
		
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Second stage decompression algorithm
		private static void stage_2 (ref long pointer, ref byte[] romData, ref byte[] bufferData, ref ulong[] tiles, short rtiles, bool alt_out, ref int out_loc)
		{
			ushort rnibbles; //remaining nibbles in this line
			ulong out_val; //output value
			ushort rom_mod = 0x10; //This one is complex. Used in maths as a power of 2, but also controls when 
											//new values are read from the rom. Just read the algorithm.
			ulong alt_out_val = 0; //If the alternate output method is used by this archive, each line is XOR'd with
										   //the line before it prior to writing to the output.
			ushort rlines; //remaining lines to decompress in this tile
			ushort mode_val; //There are two different things it can do in the main loop. This holds the value to switch between them
			ushort bufferoffset; //the buffer offset to read from next
			ushort next_out = 0; //the next nibble to be added to the output.
			short num_times = 0; //the number of times the value is repeated in the output
			
			ushort rom_val = (ushort)(romData[pointer++]*0x100); //value from the rom
			rom_val += (ushort)(romData[pointer++] & 0xFF);
			for(;rtiles > 0;rtiles--) //main loop for tiles
			{
				for (rlines = 8; rlines != 0; rlines--) //loop for lines in the tile
				{
					for (out_val = 0, rnibbles = 8; rnibbles != 0; rnibbles--) //loop for nibbles in the line
					{
						num_times--; //decrements number of times to write current value to output
						if (num_times == -1) //if -1, calculate new value
						{
							mode_val = (ushort)(rom_val / System.Math.Pow(2, (rom_mod - 8))); //determines which set of commands to perform
							if ((mode_val & 0x00FF) >= 0xFC) //determining value is 0xFC or greater
							{
								if (rom_mod < 0x0F) //determines whether or not to read another value from the rom
								{
									rom_mod += 8; //and adds 8 to rom_mod if it does
									rom_val = (ushort)((rom_val * 0x100) + (romData[pointer++] & 0xFF));
								}
								rom_mod -= 0x0D; //subtracts 0x0D from rom_mod
								num_times = (short)(((short)(rom_val / Math.Pow(2, rom_mod)) & 0x70) / 0x10); //calculates number of times to write value to output
								next_out = (ushort)((short)(rom_val / Math.Pow(2, rom_mod)) & 0x0F); //calculates next output value
							}
							else
							{
								bufferoffset = (ushort)((mode_val & 0xFF) * 2); //sets buffer offset
								rom_mod -= bufferData[bufferoffset]; //reads a buffer value, then subtracts it from rom_mod. Never greater than 0x7
								num_times = (short)((bufferData[bufferoffset+1] & 0xF0) / 0x10); //set number of times based on a buffer value. Never greater than 0x7
								next_out = (ushort)((bufferData[bufferoffset+1]) & 0x0F); //gets next output value from buffer
							}
							if (rom_mod < 9) //again, potentially load a value from the rom
							{
								rom_mod += 8; //and add 8 to rom_mod
								if(pointer < romData.Length)
									rom_val = (ushort)((rom_val * 0x100) + (romData[pointer++] & 0xFF));
							}
						}
						out_val = out_val * 0x10 + next_out; //adds next value to output
					}
					if (alt_out == false)
					{
						tiles[out_loc++] = out_val; //writes next line to output array
					}
					else
					{
						alt_out_val = alt_out_val ^ out_val; //Alternate output method. Only bits set are those different to the last line
						tiles[out_loc++] = alt_out_val;
					}
				}
			}
		}
		
		
		public struct FuckingMess{		
			/**********************************Variable block***************************************\
			|	Contains the definitions for the global variables used in the program
			\**********************************Variable block***************************************/
			public int loopcount2;
			public int tempoffset;
			public int tiles;
			public int bitoffset;
			public int loopcount;
			public FileStream infile;
			public FileStream outfile;
			public int infilelength;
			public int offset;
			public int waitingbits;
			public byte bytebuffer;
			public byte[] infilepointer;
			public byte[] workingpointer;
			public byte[] mode0cmppointer;
			public byte[] mode1cmppointer;
			public int workingoffset;
			public int mode0cmpoffset;
			public int mode1cmpoffset;
			public int outoffset;
			public bool padding;
			public bool workaround;
			public bool extended;
			public bool othervalues;
			public int result;
			public short readbuffer;
			public short checkbuffer;
			public uint[][] occurance_table;
			public uint[] linear_array;
			public ushort[] repetition_table;
			public byte currentnybble;
			
			public void init(){
				occurance_table = new uint[0x10][];
				for(int x=0; x<occurance_table.Length; x++){
					occurance_table[x] = new uint[0x08];
				}
				linear_array = new uint[0x80];
				repetition_table = new ushort[0x100];
			}
		}
		
		/***********************************Entry point*****************************************\
		|
		\***********************************Entry point*****************************************/
		public static long NComp(string srcFile, string dstFile)
		{
			FuckingMess dat = new FuckingMess();
			dat.init();
		// The original code by Nemesis allowed to pass a pointer to the location of the source
		// file to start compressing from, but I'm not using it, for simplicity
			long Pointer = 0;
			dat.offset = (int)Pointer; //Why? It's 0.
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//File handling
			if(!File.Exists(srcFile)){
				return -1;
			}
			dat.infile = new FileStream(srcFile, FileMode.Open);
			dat.outfile = new FileStream(dstFile, FileMode.Create);
			dat.infilelength = (int)dat.infile.Length;
			if(dat.infilelength < dat.offset)
			{
				throw new Exception("Invalid Offset!");
			}
			dat.infilepointer = new byte[dat.infilelength - dat.offset];
			dat.mode0cmppointer = new byte[dat.infilelength - dat.offset];
			dat.mode1cmppointer = new byte[dat.infilelength - dat.offset];
			dat.infile.Seek(dat.offset, SeekOrigin.Begin);
			dat.infile.Read(dat.infilepointer, 0, dat.infilelength - dat.offset);
			
		//	printf("\n\nBeginning mode 0 compression\n");
			dat.workingpointer = dat.mode0cmppointer;
			compress(0, ref dat);
			dat.mode0cmpoffset = dat.workingoffset;
		//	printf("\n\nBeginning mode 1 compression\n");
			dat.workingoffset = 0;
			dat.tempoffset = 0;
			dat.waitingbits = 0;
			dat.bitoffset = 4;
			dat.workingpointer = dat.mode1cmppointer;
			for(dat.loopcount = ((dat.infilelength - dat.offset) - 4); dat.loopcount > 0; dat.loopcount -= 4)
			{
				dat.infilepointer[dat.loopcount] ^= dat.infilepointer[dat.loopcount-4];
				dat.infilepointer[dat.loopcount+1] ^= dat.infilepointer[dat.loopcount-3];
				dat.infilepointer[dat.loopcount+2] ^= dat.infilepointer[dat.loopcount-2];
				dat.infilepointer[dat.loopcount+3] ^= dat.infilepointer[dat.loopcount-1];
			}
			compress(1, ref dat);
			dat.mode1cmpoffset = dat.workingoffset;
		
			if(dat.mode1cmpoffset < dat.mode0cmpoffset)
			{
				dat.outfile.Write(dat.mode1cmppointer, 0, dat.mode1cmpoffset);
		//		printf("\n\n\n%s compressed into %s from offset %i using mode 1\nOriginal filesize:\t%i\nCompressed filesize:\t%i\nPercentage of original:\t%f", argv[1], argv[2], offset, infilelength, mode1cmpoffset, (((float)mode1cmpoffset / (float)infilelength) * 100));
			}
			else
			{
				dat.outfile.Write(dat.mode0cmppointer, 0, dat.mode0cmpoffset);
		//		printf("\n\n\n%s compressed into %s from offset %i using mode 0\nOriginal filesize:\t%i\nCompressed filesize:\t%i\nPercentage of original:\t%f", argv[1], argv[2], offset, infilelength, mode0cmpoffset, (((float)mode0cmpoffset / (float)infilelength) * 100));
			}
		
			if ((dat.outfile.Position & 1)>0) dat.outfile.Seek(1, SeekOrigin.Current);
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Cleanup
			dat.infile.Close();
			dat.outfile.Close();
		
			return 0;
		}
		
		private static int compress(int mode, ref FuckingMess dat)
		{
		//	printf("Profiling data....\t\t\t\t");
		/////////////////////////////////////////////////////////////////////////////////////////
		//Load value/repeatcount template into occurance table and linear array
			dat.tiles = ((dat.infilelength - dat.offset) / 0x20);
			int currentval = getnybble(ref dat);
			int tempval = 0;
			int hitcount = 0;
			for(dat.loopcount = 0; dat.loopcount < 0x10; dat.loopcount++)
			{
				for(dat.loopcount2 = 0; dat.loopcount2 < 0x08; dat.loopcount2++)
				{
					dat.occurance_table[dat.loopcount][dat.loopcount2] = (uint)((dat.loopcount << 0x18) | (dat.loopcount2 << 0x10));
					dat.linear_array[(dat.loopcount2 << 4) | dat.loopcount] = (uint)((dat.loopcount << 0x18) | (dat.loopcount2 << 0x10));
				}
			}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Calculate occurance values
			for(dat.loopcount = 2; dat.loopcount < ((dat.infilelength - dat.offset) * 2); dat.loopcount++)
			{
				tempval = getnybble(ref dat);
				if((tempval != currentval) || (hitcount >= 7))
				{
					dat.occurance_table[currentval][hitcount]++;
					dat.linear_array[(hitcount << 4) | currentval] = dat.occurance_table[currentval][hitcount];
					currentval = tempval;
					hitcount = 0;
				}
				else
				{
					hitcount++;
				}
			}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Sort linear array
			dat.tempoffset = 0;
			int tempval1 = 0;
			for(dat.loopcount2 = 0; dat.loopcount2 < 0x80; dat.loopcount2++)
			{
				for(dat.loopcount = 0; dat.loopcount < 0x7F; dat.loopcount++)
				{
					if(((dat.linear_array[dat.loopcount + 1]) & 0xFFFF) > ((dat.linear_array[dat.loopcount]) & 0xFFFF))
					{
						tempval1 = (int)dat.linear_array[dat.loopcount];
						dat.linear_array[dat.loopcount] = dat.linear_array[dat.loopcount + 1];
						dat.linear_array[dat.loopcount + 1] = (uint)tempval1;
					}
				}
			}
		//	printf("Complete\n");
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Write header
			writedata(mode, 1, ref dat);
			writedata(dat.tiles, 15, ref dat);
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Generate repetition buffer
		//	printf("Generating repetition dictionary....\t\t");
			int packet_length = 0x07;
			int loopcount3 = 0;
			int[] increase_array = new int[0x100];
		
		//Generate the base repetition table from the linear array
			for(dat.loopcount = 0; dat.loopcount < 0x100; dat.loopcount++)
			{
				dat.repetition_table[dat.loopcount] = 0;
			}
			for(dat.loopcount = 0; (dat.loopcount < 0x80) && ((dat.linear_array[dat.loopcount] & 0xFFFF) > 0); dat.loopcount++)
			{
				dat.repetition_table[dat.loopcount] = (ushort)generate_entry(8, (byte)((dat.linear_array[dat.loopcount] & 0x00FF0000) >> 0x10), (byte)((dat.linear_array[dat.loopcount] & 0xFF000000) >> 0x18));
			}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Begin repetition table optimisation loop
			for(;;)
			{
		//Wipe the increase array
				for(dat.loopcount = 0; dat.loopcount < 0x100; dat.loopcount++)
				{
					increase_array[dat.loopcount] = 0;
				}
		//Calculate increase values
				for(dat.loopcount = 0; (dat.loopcount < 0xFC) && (dat.repetition_table[dat.loopcount] & 0x0F00) > 0; dat.loopcount++)
				{
					if(((dat.repetition_table[dat.loopcount] & 0xFF00) > 0x100) && ((((1 << (8 - ((dat.repetition_table[dat.loopcount] & 0x0F00) >> 8))) * 2) + dat.loopcount) < 0xFC))
					{
						increase_array[dat.loopcount] = (int)(dat.occurance_table[dat.repetition_table[dat.loopcount] & 0x000F][(dat.repetition_table[dat.loopcount] & 0x00F0) >> 4] & 0xFFFF);
						increase_array[dat.loopcount] |= (dat.repetition_table[dat.loopcount] & 0x000F) << 24;
						increase_array[dat.loopcount] |= ((dat.repetition_table[dat.loopcount] & 0x00F0) >> 4) << 16;
		
						int bufferedval = 0;
						for(dat.loopcount2 = (0xFC - (1 << (8 - ((int)(dat.repetition_table[dat.loopcount] & 0x0F00) >> 8)))); dat.loopcount2 < 0xFC; dat.loopcount2++)
						{
							dat.othervalues = false;
							for(loopcount3 = 0; loopcount3 < 0xFC; loopcount3++)
							{
								if(((dat.repetition_table[loopcount3] & 0x000F) == (dat.repetition_table[dat.loopcount2] & 0x000F)) && ((dat.repetition_table[dat.loopcount2] & 0x0F00) > 0)&& ((dat.repetition_table[loopcount3] & 0x0F00) > 0))
								{
									dat.othervalues = true;
								}
							}
							if(((dat.repetition_table[dat.loopcount2] & 0x0F00) > 0) & (bufferedval != dat.repetition_table[dat.loopcount2]))
							{
								int addvalue = 0;
								if(dat.othervalues == true)
								{
									addvalue = -16;
								}
								else
								{
									addvalue = -24;
								}
								increase_array[dat.loopcount] = (int)(((increase_array[dat.loopcount] - (addvalue + ((dat.occurance_table[dat.repetition_table[dat.loopcount2] & 0x000F][(dat.repetition_table[dat.loopcount2] & 0x00F0) >> 4] & 0xFFFF) * (5 + (8 - ((dat.repetition_table[dat.loopcount2] & 0x0F00) >> 8)))))) & 0x0000FFFF) | (increase_array[dat.loopcount] & 0xFFFF0000));
								bufferedval = dat.repetition_table[dat.loopcount2];
							}
						}
						if((increase_array[dat.loopcount] & 0x0000FFFF) < 0x8000)
						{
							increase_array[dat.loopcount] = (int)(((uint)(increase_array[dat.loopcount] & 0xFFFF0000)) | (uint)((int)((float)((float)1 / (float)(1 << (8 - ((dat.repetition_table[dat.loopcount] & 0x0F00) >> 8)))) * (dat.occurance_table[(dat.repetition_table[dat.loopcount] & 0x000F)][((dat.repetition_table[dat.loopcount] & 0x00F0) >> 4)] & 0x0000FFFF)) & 0x0000FFFF));
						}
					}
				}
		
		//sort increase array
				for(dat.loopcount2 = 0; dat.loopcount2 < 0xFC; dat.loopcount2++)
				{
					for(dat.loopcount = 0; dat.loopcount < 0xFC; dat.loopcount++)
					{
						if(((increase_array[dat.loopcount + 1] & 0x8000) != 0) | ((increase_array[dat.loopcount] & 0x8000) != 0))
						{
							if((increase_array[dat.loopcount] & 0xFFFF) > (increase_array[dat.loopcount + 1] & 0xFFFF))
							{
								tempval1 = increase_array[dat.loopcount];
								increase_array[dat.loopcount] = increase_array[dat.loopcount + 1];
								increase_array[dat.loopcount + 1] = tempval1;
							}
						}
						else
						{
							if((increase_array[dat.loopcount + 1] & 0xFFFF) > (increase_array[dat.loopcount] & 0xFFFF))
							{
								tempval1 = increase_array[dat.loopcount];
								increase_array[dat.loopcount] = increase_array[dat.loopcount + 1];
								increase_array[dat.loopcount + 1] = tempval1;
							}
						}
					}
				}
		
		//If no improvements can be made, exit
				if(((increase_array[0] & 0x00008000) > 0) | ((increase_array[0] & 0x0000FFFF) == 0))
				{
					break;
				}
		
		//Find entry to be modified and reduce bitcount
				bool finddone = false;
				for(dat.loopcount2 = 0; (!finddone) && (dat.loopcount2 < 0xFC); dat.loopcount2++)
				{
					for(dat.loopcount = 0; ((((((uint)(increase_array[dat.loopcount2] & 0xFF000000) >> 24)) | ((uint)((increase_array[dat.loopcount2] & 0x00FF0000) >> 12))) ^ (dat.repetition_table[dat.loopcount] & 0x00FF)) != 0) & (dat.loopcount < 0xFC); dat.loopcount++)
					{
					}
					if(dat.loopcount < 0xFC)
					{
						dat.repetition_table[dat.loopcount] -= 0x100;
						finddone = true;
					}
					else
					{
						break;
					}
				}
		
		//Shift values in array along
				for(dat.loopcount2 = (0xFB - (1 << (8 - ((dat.repetition_table[dat.loopcount] >> 8) + 1)))); dat.loopcount2 >= dat.loopcount; dat.loopcount2--)
				{
					dat.repetition_table[dat.loopcount2 + (1 << (8 - ((dat.repetition_table[dat.loopcount] >> 8) + 1)))] = dat.repetition_table[dat.loopcount2];
				}
		
		//Lengthen modified entry
				for(dat.loopcount2 = dat.loopcount; dat.loopcount2 < ((1 << (8 - (dat.repetition_table[dat.loopcount] >> 8))) + dat.loopcount); dat.loopcount2++)
				{
					dat.repetition_table[dat.loopcount2] = dat.repetition_table[dat.loopcount];
				}
			}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Load index values of entries in repetition table back into occurance table
			uint tempstore = 0xFFFFFFFF; //Was int, switched to uint because this value is -1 as int.
			for(dat.loopcount = 0; dat.loopcount < 0xFC; dat.loopcount++)
			{
				if((tempstore != dat.repetition_table[dat.loopcount]) && ((dat.repetition_table[dat.loopcount] & 0x0F00) != 0))
				{
					dat.occurance_table[dat.repetition_table[dat.loopcount] & 0x000F][(dat.repetition_table[dat.loopcount] & 0x00F0) >> 4] = (uint)(((uint)(0x80000000 | (uint)dat.loopcount)) | ((uint)((dat.repetition_table[dat.loopcount] >> 8) << 0x14)));
				}
				tempstore = dat.repetition_table[dat.loopcount];
			}
		//	printf("Complete\n");
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//First stage compression
		//	printf("Compressing repetition dictionary...\t\t");
			int writtenvalues = 0;
			bool newval = true;
			for(dat.loopcount = 0x00; dat.loopcount < 0x10; dat.loopcount++)
			{
				newval = true;
				for(dat.loopcount2 = 0; (dat.loopcount2 < 0x100) && (writtenvalues < 0x100);)
				{
					for(; (dat.loopcount2 < 0x100) && (((dat.repetition_table[dat.loopcount2] & 0x000F) != dat.loopcount) || ((dat.repetition_table[dat.loopcount2] & 0x0F00) == 0)); dat.loopcount2++)
					{
					}
					if(dat.loopcount2 < 0x100)
					{
						if(newval)
						{
							writedata(8, 4, ref dat);
							writedata(dat.loopcount, 4, ref dat);
							newval = false;
						}
						packet_length = ((dat.repetition_table[dat.loopcount2] >> 8) & 0x000F);
						writedata(dat.repetition_table[dat.loopcount2] >> 4, 4, ref dat);
						writedata(packet_length, 4, ref dat);
						writtenvalues += (1 << (8 - packet_length));
						writedata(dat.loopcount2 >> (8 - packet_length), 8, ref dat);
						dat.loopcount2 += (1 << (8 - packet_length));
					}
				}
			}
			flush_writebuffer(ref dat);
			writedata(0xFF, 8, ref dat);
			//printf("Complete\n");
		
		/////////////////////////////////////////////////////////////////////////////////////////
		//Second stage compression
		//	printf("Compressing file....\t\t\t\t");
			for(dat.tempoffset = 0; dat.tempoffset < (dat.infilelength - dat.offset) ;)
			{
				dat.currentnybble = (byte)getnybble(ref dat);
				for(dat.loopcount = 0; ((dat.tempoffset + ((dat.loopcount+1) / 2)) < (dat.infilelength - dat.offset)) && (checknybble(dat.loopcount, ref dat) == dat.currentnybble) && (dat.loopcount < 0x07); dat.loopcount++)
				{
				}
				if(((dat.occurance_table[dat.currentnybble][dat.loopcount]) & 0x80000000) > 0)
				{
					int temp166 = (int)(((dat.occurance_table[dat.currentnybble][dat.loopcount] >> 0x14) & 0x0000000F) - 1);
					for(dat.loopcount2 = 7; (dat.loopcount2 >= 0) && ((temp166 - (7 - dat.loopcount2)) >= 0); dat.loopcount2--)
					{
						writedata((int)((dat.occurance_table[dat.currentnybble][dat.loopcount]) >> dat.loopcount2) & 0x00000001, 1, ref dat);
					}
					dat.tempoffset += (dat.loopcount >> 1);
					if((dat.loopcount & 0x01) > 0)
					{
						if(dat.bitoffset > 0)
						{
							dat.bitoffset = 0;
							dat.tempoffset++;
						}
						else
						{
							dat.bitoffset = 4;
						}
					}
				}
				else
				{
					writedata(0x3F, 6, ref dat);
					writedata(dat.loopcount, 3, ref dat);
					writedata(dat.currentnybble, 4, ref dat);
					dat.tempoffset += (dat.loopcount >> 1);
					if((dat.loopcount & 0x01) > 0)
					{
						if(dat.bitoffset > 0)
						{
							dat.bitoffset = 0;
							dat.tempoffset++;
						}
						else
						{
							dat.bitoffset = 4;
						}
					}
				}
			}
			flush_writebuffer(ref dat);
		//	printf("Complete\n");
		//	printf("Compressed filesize:\t\t\t\t%i", workingoffset);
		
			return 0;
		}
		
		
		/*******************************Getnybble function**************************************\
		|	Returns the next nybble in the file and increments the read offset.
		\*******************************Getnybble function**************************************/
		private static int getnybble(ref FuckingMess dat)
		{
			if(dat.bitoffset > 0)
			{
				dat.bitoffset = 0;
				return (dat.infilepointer[dat.tempoffset++] & 0x0F);
			}
			else
			{
				dat.bitoffset = 4;
				return ((dat.infilepointer[dat.tempoffset] & 0xF0) >> 4);
			}
		}
		
		
		/*******************************Checknybble function************************************\
		|	Returns the nybble at the current offset location, plus the supplied offset in
		|	nybbles, without incrementing the offset location.
		\*******************************Checknybble function************************************/
		private static int checknybble(int offset, ref FuckingMess dat)
		{
			if(dat.bitoffset > 0)
			{
				offset += 1;
			}
			if((offset & 0x01) == 0x00)
			{
				return ((dat.infilepointer[(offset / 2) + dat.tempoffset] & 0xF0) >> 4);
			}
			else
			{
				return (dat.infilepointer[(offset / 2) + dat.tempoffset] & 0x0F);
			}
		}
		
		
		/*********************************Read/Write functions**********************************\
		|	Adds the supplied bit to the write stream.
		\*********************************Read/Write functions**********************************/
		private static byte writedata(int data, int writecount, ref FuckingMess dat)
		{
			for(int loopcount = 0; loopcount < writecount; loopcount++)
			{
				dat.bytebuffer <<= 1;
				dat.bytebuffer |= (byte)(data >> ((writecount - 1) - loopcount));
				dat.waitingbits++;
				if(dat.waitingbits >= 8)
				{
		//			_write(outfile, &bytebuffer, 0x1);
					dat.workingpointer[dat.workingoffset++] = dat.bytebuffer;
					dat.waitingbits = 0;
				}
			}
			return 1;
		}
		
		
		/******************************Flush_writebuffer function*******************************\
		|	If an incomplete byte is currently waiting in the output sream, this function
		|	completes the packet with 0's and outputs it to the file.
		\******************************Flush_writebuffer function*******************************/
		private static void flush_writebuffer(ref FuckingMess dat)
		{
			if(dat.waitingbits > 0)
			{
				dat.bytebuffer <<= (8 - dat.waitingbits);
		//		_write(outfile, &bytebuffer, 0x1);
				dat.workingpointer[dat.workingoffset++] = dat.bytebuffer;
				dat.waitingbits = 0;
			}
		}
		
		
		/******************************Generate_entry function**********************************\
		|	Generates a buffer entry value from the supplied parameters.
		\******************************Generate_entry function**********************************/
		private static short generate_entry(byte packet_length, byte repeatcount, byte nybble)
		{
			short bufferentry = 0;
			bufferentry |= (short)((packet_length & 0x0F) << 8);
			bufferentry |= (short)((repeatcount & 0x0F) << 4);
			bufferentry |= (short)(nybble & 0x0F);
			return bufferentry;
		}
		
		
	}
}

