using System;
using System.IO;

/** Saxman Decompression and Compression Routines
 * 
 * Ported almost line-by-line from the KENS libraries C source code.
 * */

namespace KensNET
{
	public static class Saxman
	{
		/*** Note: I think there is a bug here somewhere. Output appears to be correct, but sometimes incomplete? ***/
		
		public enum SResult{
			SUCCESS, ERROR_UNKNOWN, ERROR_FILE_NOT_FOUND
		}
				
		//-----------------------------------------------------------------------------------------------
		// Name: SDecomp(char *SrcFile, char *DstFile, long Location, unsigned short Size)
		// Desc: Decompresses the data using the Saxman compression format
		//-----------------------------------------------------------------------------------------------
		public static SResult SDecomp(string srcFile, string dstFile, long location, ushort size)
		{
		// Files
			FileStream src;
			FileStream dst;
		
		// Info Byte, Flag, Count and Offset (with initial values)
			byte InfoByte = 0;
			byte IBP = 8;
			byte Flag = 0;
			byte Count = 0;
			ushort Offset = 0;
		//	unsigned short Size = 0;		// Size of the compressed data
		
		// Other info
			byte scratchByte;				// Used to store a Byte temporarly
			int Pointer;					// Used to store a Pointer temporarly
			int i;							// Counter
		
		//------------------------------------------------------------------------------------------------
		
			if (!File.Exists(srcFile)) return SResult.ERROR_FILE_NOT_FOUND;
			src = new FileStream(srcFile, FileMode.Open);
			dst = new FileStream(dstFile, FileMode.Create);
		
			src.Seek(location, SeekOrigin.Begin);
			
			if (size==0) size = ReadShort(src);
		
			while(true)
			{
				if (IBP==8) { IBP=0; InfoByte=(byte)src.ReadByte(); if (src.Position >= location + size) break; }
				Flag = (byte)(( InfoByte >> (IBP++) ) & 1);
				switch(Flag)
				{
					case 0:
						Offset=0; // See 3 lines below
						Offset=(ushort)src.ReadByte(); if (src.Position >= location + size) break;
						Count=(byte)src.ReadByte(); if (src.Position >= location + size) break;
						Offset = (ushort)(( Offset | ((Count & 0xF0) << 4) ) + 0x12); // Can be improved
						Offset |= (ushort)(dst.Position & 0xF000);
						Count&=0x0F;
						Count+=3;
						if(Offset>=dst.Position)
						{
							Offset -= 0x1000;
						}
						if (Offset<dst.Position)
						{
							for (i=0; i<Count; ++i)
							{
								Pointer=(int)dst.Position;
								dst.Seek(Offset + i, SeekOrigin.Begin);
								scratchByte=(byte)dst.ReadByte();
								dst.Seek(Pointer, SeekOrigin.Begin);
								dst.WriteByte(scratchByte);
							}
						}
						else
						{
							scratchByte=0;
							for (i=0; i<Count; ++i)
							{
								dst.WriteByte(scratchByte);
							}
						}
						break;
		
					case 1:
						scratchByte = (byte)src.ReadByte();
						if (src.Position >= location + size) break;
						dst.WriteByte(scratchByte);
						break;
				}
			}
		
		//------------------------------------------------------------------------------------------------
		
			dst.Close();
			src.Close();
			return SResult.SUCCESS;
		}
		
		private static ushort ReadShort(FileStream strm){
			byte[] arr = new byte[2];
			strm.Read(arr, 0, 2);
			return (ushort)((arr[0]) + (arr[1] << 8)); 
		}
		
		//-----------------------------------------------------------------------------------------------
		// Name: SComp(char *SrcFile, char *DstFile, bool WithSize)
		// Desc: Compresses the data using the Saxman compression format
		//-----------------------------------------------------------------------------------------------
		public static SResult SComp(string srcFile, string dstFile, bool withSize)
		{
		// Files
			FileStream src;
			FileStream dst;
		
		// Info Byte, IBP and Size
			byte InfoByte;
			byte IBP;
			ushort Size;
		
		// Buffer Infos
			byte[] Buffer;
			int BSize;
			int BPointer;
		
		// Data info (temp)
			byte[] Data = new byte[64];
			byte DS;
			
		// Count and Offest & Info
			int Count = 0;
			int Offset = 0;
			int IOffset = 0;
			ushort Info;
		
		// Counters
			int i, j=0, k;
		
		//----------------------------------------------------------------------------------------------------------------
		
			if (!File.Exists(srcFile)) return SResult.ERROR_FILE_NOT_FOUND;
			src = new FileStream(srcFile, FileMode.Open);
			
			BSize=(int)(src.Length+18);
			Buffer = new byte[BSize];
			src.Read(Buffer, 18, BSize-18);
			src.Close();
			dst = new FileStream(dstFile, FileMode.Create);
			if (withSize) dst.Seek(2, SeekOrigin.Current);
				
			InfoByte=0;
			IBP=0;
			BPointer=18;
			DS=0;
		
		//----------------------------------------------------------------------------------------------------------------
		
		start:
			Count=18; if (BSize-BPointer<18) { Count=BSize; Count-=BPointer; }
			k=1; // Minimal recurrence length, will contain the total recurrence length
			//i=0;
			i=BPointer-0x1000; if (i<0) i=0;
			do {
				j=0; // Will contain the total recurrence length for one loop, then will be set to 0
				while ( Buffer[i+j] == Buffer[BPointer+j] ) { if(++j>=Count) break; }
				if (j>k) { k=j; Offset=i; }
				if (i==0) i=17;
			} while (++i<BPointer);
			Count=k;
		
		//----------------------------------------------------------------------------------------------------------------
		
			if (Count==1)
			{
				InfoByte|=(byte)(1<<IBP); // 2^IBP
				
				Data[DS]=Buffer[BPointer];
				DS+=1;
		
				if (++IBP==8) { dst.WriteByte(InfoByte); dst.Write(Data,0,DS); InfoByte=IBP=DS=0; }	
			}
		
			else if (Count==2)
			{
				InfoByte|=(byte)(1<<IBP); // 2^IBP
		
				Data[DS]=Buffer[BPointer];
				DS+=1;
		
				if (++IBP==8) { dst.WriteByte(InfoByte); dst.Write(Data,0,DS); InfoByte=IBP=DS=0; }	
		
				--Count;
			}
		
			else
			{
				//IOffset = Offset - 0x24;
				IOffset = ((Offset - 0x12) & 0x0FFF) - 0x12;
		
				Info = (ushort)(( (IOffset & 0xFF) << 8 ) | ( (IOffset & 0xF00) >> 4 ) | ( (Count - 3) & 0x0F ));
		
				Data[DS]=(byte)(Info >> 8);
				Data[DS+1]=(byte)(Info & 0xFF);
				DS+=2;
		
				if (++IBP==8) { dst.WriteByte(InfoByte); dst.Write(Data,0,DS); InfoByte=IBP=DS=0; }	
			}
		
		//----------------------------------------------------------------------------------------------------------------
		
			BPointer+=Count;
			if (BPointer<BSize) goto start;
		
		//----------------------------------------------------------------------------------------------------------------
		
			dst.WriteByte(InfoByte); dst.Write(Data,0,DS); InfoByte=IBP=DS=0;
			if (withSize)
			{
				Size=(ushort)(dst.Position-2);
				dst.Seek(0, SeekOrigin.Begin);
				WriteShort(dst, Size);
			}
			dst.Seek(0, SeekOrigin.End);
			if ((dst.Position & 1)>0) dst.Seek(1, SeekOrigin.Current);
			dst.Close();
			return SResult.SUCCESS;
		}		
		
		private static void WriteShort(FileStream strm, ushort val){
			strm.WriteByte((byte)(val&0xFF));
			strm.WriteByte((byte)((val>>8)&0xFF)); 
		}
	}
}

